/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetDeviceFileIdCommand
extends VerificationCommand {
    private static String m_arg1 = "-getdevfileid";
    private String m_deviceFile;
    private boolean m_fileFound = false;
    private boolean m_fileDeviceFile = false;

    public GetDeviceFileIdCommand(String nodeName, String filenameFull) {
        super(nodeName, null, null);
        this.m_deviceFile = filenameFull;
        String[] args = new String[]{m_arg1, this.m_deviceFile};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("GetDeviceFileIdCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetDeviceFileIdCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("retrieval of file device ID failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("GetFileDeviceIDCommand:: execute() The Exectask output for node :" + this.getNodeName() + " is : " + reoutput));
        }
        this.analyzeDeviceId(reoutput, result);
        return true;
    }

    public boolean isFileFound() {
        return this.m_fileFound;
    }

    public boolean isFileDeviceFile() {
        return this.m_fileDeviceFile;
    }

    private boolean analyzeDeviceId(String etoutput, Result result) {
        String matchFileNotFound = "File does not exist.";
        String matchFileNotDevice = "File not a devicefile.";
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Error while Retrieving device file ID");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        if (txtVal != null && txtVal.length() > 0) {
            txtVal = txtVal.trim();
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("GetFileDeviceIDCommand:: analyzeDeviceId() The output obtained from node :" + this.getNodeName() + " is : " + txtVal));
        }
        String exectaskErr = VerificationUtil.fetchError(etoutput);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("GetFileDeviceIDCommand:: analyzeDeviceId() The exectask error from node :" + this.getNodeName() + " is : " + exectaskErr));
        }
        String vResult = VerificationUtil.fetchVerificationResult(etoutput);
        if (txtVal != null && txtVal.length() > 0 && vResult.contains("0")) {
            this.m_fileFound = true;
            this.m_fileDeviceFile = true;
            result.addResultInfo(txtVal);
            result.setStatus(1);
            Trace.out((int)5, (String)"Command succeeded");
            return true;
        }
        if (exectaskErr != null && exectaskErr.contains("File does not exist.")) {
            this.m_fileFound = false;
            this.m_fileDeviceFile = false;
            result.addTraceInfo("*** Device File not found.");
            result.addErrorInfo("Device File '" + this.m_deviceFile + "' not found on the specified node.");
            result.setStatus(3);
            return false;
        }
        if (exectaskErr != null && exectaskErr.contains("File not a devicefile.")) {
            Trace.out((String)"GetFileDeviceIDCommand:: analyzeDeviceId() File found but it is not a device file.");
            this.m_fileFound = true;
            this.m_fileDeviceFile = false;
            result.addTraceInfo("*** File not a Device File.");
            result.addErrorInfo("File '" + this.m_deviceFile + "' is not a device file.");
            result.setStatus(3);
            return false;
        }
        Trace.out((String)"GetFileDeviceIDCommand:: analyzeDeviceId() Error Case");
        this.m_fileFound = false;
        this.m_fileDeviceFile = false;
        result.addTraceInfo("*** Failed to retrieve device ID for specified device file.");
        result.addErrorInfo("Device File ID for '" + this.m_deviceFile + "'could not be retrieved.");
        result.setStatus(3);
        return false;
    }
}

